<?php $__env->startSection('title',trans('Contact List')); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <section class="account-section overflow-hidden">
        <div class="container">
            <div class="cmn__card betting--card mw-750">
                <div class="card__body">
                    <div class="bet__wrapper">
                        <div class="pick__area">
                            <h6 class="pick__title"><?php echo e(trans('Add Contact for future transaction')); ?></h6>
                            <form class="add-people-form">
                                <div class="form-group text-start">
                                    <div class="input-group mb-3">
                                    <span class="input-group-text">
                                        <i class="la la-user"></i>
                                    </span>
                                        <input type="text" class="form--control form-control shadow-none outline-0"
                                               name="search" placeholder="<?php echo e(trans('Username, Email or Phone')); ?>">
                                        <button
                                            class="input-group-text cmn-btn px-3 bg--theme bg-success text-white border-0 fs-14 checkContactList"
                                            type="button"><?php echo e(trans('Add People')); ?>

                                        </button>


                                    </div>
                                    <span class="text-danger errors ps-5"></span>
                                </div>
                            </form>

                            <div class="oponent__wrapper">
                                <h6 class="oponent__title mb-2"><?php echo e(trans('Most Recent Opponents')); ?></h6>
                                <ul>
                                    <?php $__empty_1 = true; $__currentLoopData = $contactList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php if(isset($item) && $item == false): ?>
                                            <?php continue; ?>
                                        <?php endif; ?>
                                        <li class="oponent-item">
                                            <div class="thumb">
                                                <a href="javascript:void(0)">
                                                    <img src="<?php echo e(getFile(config('location.user.path').@$item['info']['image'])); ?>" alt="user">
                                                </a>
                                            </div>
                                            <div class="content">
                                                <h6 class="oponent-title">
                                                    <a href="javascript:void(0)">
                                                        <?php echo app('translator')->get(@$item['info']['fullname']); ?>
                                                    </a>
                                                </h6>
                                                <span><?php echo app('translator')->get(@$item['info']['profileName']); ?></span>
                                            </div>


                                            <?php if($item['receiver_id'] == auth()->id() && $item['status'] ==0): ?>
                                            <a href="<?php echo e(route('user.acceptRequest',$item['id'])); ?>" title="<?php echo e(trans('Accept Request')); ?>" class="add-btn bg-success "><i class="las la-check-circle"></i></a>
                                            <a href="<?php echo e(route('user.rejectRequest',$item['id'])); ?>" title="<?php echo e(trans('Cancel Request')); ?>" class="add-btn bg-info"><i class="las la-times"></i></a>
                                            <?php elseif($item['user_id'] == auth()->id() && $item['status'] ==0): ?>
                                                <a href="javascript:void(0)" title="<?php echo e(trans('Request Pending')); ?>" class="add-btn bg-warning pointer"><i class="las la-spinner"></i></a>
                                            <?php elseif($item['modified_by'] == auth()->id() && $item['status'] ==2): ?>
                                                <a href="<?php echo e(route('user.unblockConnection',$item['id'])); ?>" title="<?php echo e(trans('Unblock')); ?>" class="add-btn bg-primary "><i class="las la-unlock"></i></a>
                                            <?php elseif($item['status'] == 1): ?>
                                                <a href="<?php echo e(route('user.blockConnection',$item['id'])); ?>" title="<?php echo e(trans('Blocked')); ?>" class="add-btn bg-danger"><i class="las la-ban"></i></a>
                                            <?php endif; ?>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <li class="oponent-item">
                                            <div class="thumb">
                                                <a href="javascript:void(0)">
                                                </a>
                                            </div>

                                            <div class="content">
                                                <h6 class="oponent-title">
                                                    <p><?php echo app('translator')->get('No contact in your list'); ?></p>
                                                </h6>
                                            </div>
                                        </li>
                                    <?php endif; ?>
                                </ul>

                                <div class="mt-3">
                                    <?php echo e($contactList->appends($_GET)->links($theme.'partials.pagination')); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>


        $(document).ready(function () {
            "use strict";
            $('input[name=search]').on('keypress', function () {
                $(this).parents('.add-people-form').find('.text-danger').addClass('d-none').removeClass('d-block');
            })


            $('.checkContactList').on('click', function () {
                var search = $('input[name=search]').val();
                if (search.length == 0) {
                    Notiflix.Notify.Warning(`<?php echo e(trans('Please fill up the feild')); ?>`);
                    return 0;
                }

                $.ajax({
                    url: "<?php echo e(route('user.checkContact')); ?>",
                    type: 'POST',
                    data: {
                        search : search
                    },
                    success(data) {
                        console.log(data);
                        if (data.success) {
                            $('input[name=search]').val('');
                            $('input[name=search]').parents('.add-people-form').find('.text-danger').addClass('d-block').removeClass('d-none');
                            Notiflix.Notify.Success(`${data.success}`);
                        }
                    },
                    complete: function () {
                    },
                    error(err) {
                        var errors = err.responseJSON;
                        for (var obj in errors) {
                            $('.errors').text(`${errors[obj]}`)
                        }
                        $('input[name=search]').parents('.add-people-form').find('.text-danger').addClass('d-block').removeClass('d-none');
                    }
                });


            })


        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/themes/darkmode/user/escrow/contact-list.blade.php ENDPATH**/ ?>