<?php $__env->startSection('title', trans('Ask For Help')); ?>
<?php $__env->startSection('content'); ?>

    <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <section class="blog-section pt-100 pb-100">
        <div class="container">

            <div class="row justify-content-center g-4">

                <div class="<?php echo e((in_array($escrow->payment_status, [2,3])) ? 'col-md-5' : 'col-md-12'); ?> ">
                    <article>
                        <div class="post-details">
                            <div class="post-inner">
                                <div class="post-header">
                                    <h6><span
                                            class="text--base pe-3"><?php echo e(trans('Title')); ?> :</span> <?php echo e(trans($escrow->title)); ?>

                                    </h6>
                                </div>
                                <div class="post-content mt-3">
                                    <div class="entry-content ps-0">
                                        <p class="mb-3">
                                            <span class="text--base pe-3"><?php echo e(trans('Invoice ID')); ?> :</span>
                                            <?php echo e($escrow->invoice); ?>

                                        </p>

                                        <p class="mb-3">
                                            <span class="text--base pe-3"><?php echo e(trans('Amount')); ?> :</span>
                                            <?php echo e(trans(config('basic.currency_symbol'))); ?><?php echo e(getAmount($escrow->amount)); ?>

                                        </p>
                                        <p class="mb-3">
                                            <span class="text--base pe-3"><?php echo e(trans('Charge')); ?> :</span>
                                            <?php echo e(trans(config('basic.currency_symbol'))); ?><?php echo e(getAmount($data['charge'])); ?>

                                        </p>

                                        <p class="mb-4">
                                            <span class="text--base pe-3"><?php echo e(trans('Status')); ?> :</span>
                                            <?php if($escrow['status'] == 0): ?>
                                                <span class="badge bg-secondary"><?php echo e(trans('Pending')); ?></span>
                                            <?php elseif($escrow['status'] == 2): ?>
                                                <span class="badge bg-danger"><?php echo e(trans('Rejected')); ?></span>
                                            <?php elseif($escrow['status'] == 1 && $escrow['payment_status'] == 0): ?>
                                                <span class="badge bg-info"><?php echo e(trans('Hold')); ?></span>
                                            <?php elseif($escrow['status'] == 1 && $escrow['payment_status'] == 1): ?>
                                                <span class="badge bg-success"><?php echo e(trans('Completed')); ?></span>
                                            <?php elseif($escrow['status'] == 1 && $escrow['payment_status'] == 2): ?>
                                                <span class="badge bg-warning"><?php echo e(trans('Disputed')); ?></span>
                                            <?php elseif($escrow['status'] == 1 && $escrow['payment_status'] == 3): ?>
                                                <span class="badge bg-primary"><?php echo e(trans('Resolved by Admin')); ?></span>
                                            <?php endif; ?>
                                        </p>

                                        <?php if($escrow['status'] == 1 && $escrow['payment_status'] == 3): ?>
                                            <p class="mb-4">
                                                <span class="text--base pe-3"><?php echo e(trans('Justice Favor')); ?> :</span>
                                                <?php echo e(optional($escrow->favor)->username); ?>

                                            </p>
                                        <?php endif; ?>




                                        <?php if($escrow->report): ?>
                                            <p class="mb-3 mt-2">
                                                <span class="text--base pe-3"><?php echo e(trans('Report')); ?> :</span>
                                                <?php echo app('translator')->get($escrow->report); ?>
                                            </p>
                                            <p class="mb-4">
                                                <span class="text--base pe-3"><?php echo e(trans('Reported By')); ?> :</span>
                                                <?php echo e(optional($escrow->reporter)->username); ?>

                                            </p>
                                        <?php endif; ?>

                                        <p class="mb-3">
                                            <span class="text--base pe-3"><?php echo e(trans('Rules')); ?> :</span>
                                            <?php echo app('translator')->get($escrow->rules); ?>
                                        </p>
                                        <?php if($escrow->image): ?>
                                            <p class="mb-4 d-flex">
                                                <span class="text--base pe-1"><?php echo e(trans('Documents')); ?> :</span>
                                                <a href="<?php echo e($data['file_location']); ?>"
                                                   class="text-white"><?php echo e($escrow->image); ?></a>
                                            </p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </article>

                </div>


                <?php if(in_array($escrow->payment_status, [2,3])): ?>
                    <div class="col-md-7">
                        <div class="report  justify-content-center" id="pushChatArea">

                            <audio id="myAudio">
                                <source src="<?php echo e(asset('assets/admin/css/sound.mp3')); ?>" type="audio/mpeg">
                            </audio>

                            <div class="card ">

                                <div class="adiv flex-row justify-content-start text-white">
                                    <p class="p-2 "><i class="las la-users "></i> <?php echo e(trans('Conversation')); ?></p>
                                </div>


                                <div class="chat-length" ref="chatArea">


                                    <div v-for="(item, index) in items">
                                        <div
                                            v-if="item.chat_notificational_id == auth_id && item.chat_notificational_type == auth_model"
                                            class="d-flex flex-row justify-content-end p-3 "
                                            :title="item.chat_notificational.username">
                                            <div class="bg-white me-2 pt-1 pb-4  ps-2 pe-2 position-relative mw-130">
                                                <span class="text-wa">{{item.description}}</span>
                                                <span class="timmer">{{item.formatted_date}}</span>

                                            </div>
                                            <img
                                                :src="item.chat_notificational.photo"
                                                width="30" height="30">
                                        </div>

                                        <div v-else="item.chat_notificational_id != auth_id"
                                             class="d-flex flex-row justify-content-start p-3  "
                                             :title="item.chat_notificational.username">
                                            <img
                                                :src="item.chat_notificational.photo"
                                                width="30" height="30">
                                            <div class="chat ms-2 pt-1 pb-4  ps-2 pe-5 position-relative mw-130">
                                                {{item.description}}
                                                <span class="timmer">
                                                {{item.formatted_date}}</span>
                                            </div>
                                        </div>


                                    </div>


                                </div>

                                <?php if($escrow->payment_status == 2): ?>

                                    <form @submit.prevent="send" enctype="multipart/form-data" method="post">
                                        <div class="writing-box d-flex justify-content-between align-items-center">

                                            <div class="input--group px-3 ">
                                                <input class="form--control type_msg" v-model.trim="message"
                                                       placeholder="<?php echo e(trans('Type your message')); ?>"/>
                                            </div>
                                            <div class="send text-center">
                                                <button type="button" class="btn btn-success " @click="send"><i
                                                        class="las la-paper-plane "></i>
                                                </button>
                                            </div>
                                        </div>

                                    </form>
                                <?php endif; ?>
                            </div>

                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>

    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

    <script>
        'use strict';
        let pushChatArea = new Vue({
            el: "#pushChatArea",
            data: {
                items: [],
                auth_id: "<?php echo e(auth()->id()); ?>",
                auth_model: "App\\Models\\User",
                message: ''
            },
            beforeMount() {
                this.getNotifications();
                this.pushNewItem();
            },
            methods: {
                getNotifications() {
                    let app = this;
                    axios.get("<?php echo e(route('user.push.chat.show',$escrow->id)); ?>")
                        .then(function (res) {
                            app.items = res.data;
                        })
                },

                pushNewItem() {
                    let app = this;
                    // Pusher.logToConsole = true;
                    let pusher = new Pusher("<?php echo e(env('PUSHER_APP_KEY')); ?>", {
                        encrypted: true,
                        cluster: "<?php echo e(env('PUSHER_APP_CLUSTER')); ?>"
                    });

                    let channel = pusher.subscribe('user-chat-notification.' + "<?php echo e($escrow->id); ?>");
                    channel.bind('App\\Events\\UserChatNotification', function (data) {
                        app.items.push(data.message);

                        var x = document.getElementById("myAudio");
                        x.play();


                        Vue.nextTick(() => {
                            let messageDisplay = app.$refs.chatArea
                            messageDisplay.scrollTop = messageDisplay.scrollHeight
                        })


                    });
                    channel.bind('App\\Events\\UpdateChatUserNotification', function (data) {

                        app.getNotifications();

                        console.log('update')
                    });
                },

                send() {
                    let app = this;
                    if (app.message.length == 0) {
                        Notiflix.Notify.Failure(`<?php echo e(trans('Type your message')); ?>`);
                        return 0;
                    }

                    axios.post("<?php echo e(route('user.push.chat.newMessage')); ?>", {
                        escrowId: "<?php echo e($escrow->id); ?>",
                        message: app.message
                    }).then(function (res) {

                        if (res.data.errors) {
                            var err = res.data.errors;
                            for (const property in err) {
                                Notiflix.Notify.Failure(`${err[property]}`);
                            }
                            return 0;
                        }

                        app.message = '';

                        if (res.data.success == true) {

                            Vue.nextTick(() => {
                                let messageDisplay = app.$refs.chatArea
                                messageDisplay.scrollTop = messageDisplay.scrollHeight
                            })
                        }
                    }).catch(function (error) {

                    });

                }
            }
        });
    </script>




    <?php if($errors->any()): ?>
        <script>
            'use strict';
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Notiflix.Notify.Failure(`<?php echo e(trans($error)); ?>`);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/themes/darkmode/user/escrow/chat.blade.php ENDPATH**/ ?>