<?php $__env->startSection('title',trans('Profile Settings')); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <section class="privacy pt-100 pb-100 section--bg overflow-hidden">
       <br> <div class="container">

            <div class="row">
                <div class="col-sm-4">
                    <div class="card secbg ">
                        <div class="card-body">
                            <form method="post" action="<?php echo e(route('user.updateProfile')); ?>"
                                  enctype="multipart/form-data">
                                <div class="input--group">
                                    <?php echo csrf_field(); ?>
                                    <div class="image-input ">
                                        <label for="image-upload" id="image-label"><i
                                                class="fas fa-upload"></i></label>
                                        <input type="file" name="image" placeholder="<?php echo app('translator')->get('Choose image'); ?>" id="image">
                                        <img id="image_preview_container" class="preview-image max-width-200"
                                             src="<?php echo e(getFile(config('location.user.path').$user->image)); ?>"
                                             alt="preview image">
                                    </div>
                                    <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e(trans($message)); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                                </div>
                                <div class="input--group">
                                    <p><?php echo app('translator')->get('Joined At'); ?> <?php echo app('translator')->get($user->created_at->format('d M, Y g:i A')); ?></p>
                                </div>
                                <div class="input--group text-center text-md-left">
                                    <button type="submit" class="cmn-btn w-100">
                                        <span><?php echo app('translator')->get('Image Update'); ?></span></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

                <div class="col-sm-8">
                    <div class="card secbg">
                        <div class="card-body">
                            <ul class="nav nav-tabs" id="myTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <a class="nav-link   <?php echo e($errors->has('profile') ? 'active' : ($errors->has('password') ? '' : 'active')); ?>"
                                       data-bs-toggle="tab" data-bs-target="#home" type="button" role="tab"
                                       aria-controls="home" aria-selected="true"><?php echo app('translator')->get('Profile Information'); ?></a>
                                </li>

                                <li class="nav-item" role="presentation">
                                    <a class="nav-link <?php echo e($errors->has('password') ? 'active' : ''); ?>"
                                       data-bs-toggle="tab" data-bs-target="#password" type="button" role="tab"
                                       aria-controls="password" aria-selected="false"><?php echo app('translator')->get('Password Setting'); ?></a>
                                </li>
                            </ul>

                            <!-- Tab panes -->
                            <div class="tab-content " id="myTabContent">
                                <div id="home"
                                     role="tabpanel" aria-labelledby="home-tab"
                                     class="tab-pane fade  <?php echo e($errors->has('profile') ? 'show active' : ($errors->has('password') ? '' : 'show active')); ?>">
                                    <form action="<?php echo e(route('user.updateInformation')); ?>" method="post">
                                        <?php echo method_field('put'); ?>
                                        <?php echo csrf_field(); ?>

                                        <div class="row ">
                                            <div class="col-md-6">
                                                <div class="input--group mt-2">
                                                    <label><?php echo app('translator')->get('First Name'); ?></label>
                                                    <input class="form-control" type="text" name="firstname"
                                                           value="<?php echo e(old('firstname')?? $user->firstname); ?>">
                                                    <?php if($errors->has('firstname')): ?>
                                                        <span
                                                            class="error text-danger"><?php echo app('translator')->get($errors->first('firstname')); ?> </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="input--group mt-2">
                                                    <label><?php echo app('translator')->get('Last Name'); ?></label>
                                                    <input class="form-control" type="text" name="lastname"
                                                           value="<?php echo e(old('lastname')??$user->lastname); ?>">
                                                    <?php if($errors->has('lastname')): ?>
                                                        <span
                                                            class="error text-danger"><?php echo app('translator')->get($errors->first('lastname')); ?> </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="input--group mt-2">
                                                    <label><?php echo app('translator')->get('Username'); ?></label>
                                                    <input class="form-control" type="text" name="username"
                                                           value="<?php echo e(old('username')?? $user->username); ?>">
                                                    <?php if($errors->has('username')): ?>
                                                        <span
                                                            class="error text-danger"><?php echo app('translator')->get($errors->first('username')); ?> </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>


                                            <div class="col-md-6">
                                                <div class="input--group mt-2">
                                                    <label><?php echo app('translator')->get('Email Address'); ?></label>
                                                    <input class="form-control" type="email"
                                                           value="<?php echo e($user->email); ?>" readonly>
                                                    <?php if($errors->has('email')): ?>
                                                        <span
                                                            class="error text-danger"><?php echo app('translator')->get($errors->first('email')); ?> </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="input--group mt-2">
                                                    <label><?php echo app('translator')->get('Phone Number'); ?></label>
                                                    <input class="form-control" type="text" readonly
                                                           value="<?php echo e($user->phone); ?>">

                                                    <?php if($errors->has('phone')): ?>
                                                        <span
                                                            class="error text-danger"><?php echo app('translator')->get($errors->first('phone')); ?> </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>

                                            <div class="col-md-6">
                                                <div class="input--group mt-2">
                                                    <label><?php echo app('translator')->get('Preferred language'); ?></label>
                                                    <select name="language_id" id="language_id" class="form-control">
                                                        <option value="" disabled><?php echo app('translator')->get('Select Language'); ?></option>
                                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $la): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($la->id); ?>"

                                                                <?php echo e(old('language_id', $user->language_id) == $la->id ? 'selected' : ''); ?>><?php echo app('translator')->get($la->name); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>

                                                    <?php if($errors->has('language_id')): ?>
                                                        <span
                                                            class="error text-danger"><?php echo app('translator')->get($errors->first('language_id')); ?> </span>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="input--group mt-2">
                                            <label><?php echo app('translator')->get('Address'); ?></label>
                                            <textarea class="form-control" name="address"
                                                      rows="5"><?php echo e(old('address',$user->address)); ?></textarea>
                                            <?php if($errors->has('address')): ?>
                                                <span class="error text-danger"><?php echo app('translator')->get($errors->first('address')); ?> </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="form-group mt-3">
                                            <button type="submit" class="cmn-btn w-100">
                                                <?php echo app('translator')->get('Update User'); ?></button>
                                        </div>
                                    </form>
                                </div>

                                <div id="password"
                                     role="tabpanel" aria-labelledby="password-tab"
                                     class="tab-pane fade <?php echo e($errors->has('password') ? 'show active' : ''); ?>   ">

                                    <form method="post" action="<?php echo e(route('user.updatePassword')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <div class="form-group mt-4">
                                            <label><?php echo app('translator')->get('Current Password'); ?></label>
                                            <input id="password" type="password" class="form-control"
                                                   name="current_password" autocomplete="off">
                                            <?php if($errors->has('current_password')): ?>
                                                <span
                                                    class="error text-danger"><?php echo app('translator')->get($errors->first('current_password')); ?> </span>
                                            <?php endif; ?>
                                        </div>
                                        <div class="input--group mt-4">
                                            <label><?php echo app('translator')->get('New Password'); ?></label>
                                            <input id="password" type="password" class="form-control"
                                                   name="password" autocomplete="off">
                                            <?php if($errors->has('password')): ?>
                                                <span
                                                    class="error text-danger"><?php echo app('translator')->get($errors->first('password')); ?> </span>
                                            <?php endif; ?>
                                        </div>

                                        <div class="input--group ">
                                            <label><?php echo app('translator')->get('Confirm Password'); ?></label>
                                            <input id="password_confirmation" type="password"
                                                   name="password_confirmation" autocomplete="off"
                                                   class="form-control">
                                            <?php if($errors->has('password_confirmation')): ?>
                                                <span
                                                    class="error text-danger"><?php echo app('translator')->get($errors->first('password_confirmation')); ?> </span>
                                            <?php endif; ?>
                                        </div>

                                        <div class="input--group">
                                            <button type="submit"
                                                    class=" cmn-btn w-100"><?php echo app('translator')->get('Update Password'); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        $(document).on('click', '#image-label', function () {
            $('#image').trigger('click');
        });
        $(document).on('change', '#image', function () {
            var _this = $(this);
            var newimage = new FileReader();
            newimage.readAsDataURL(this.files[0]);
            newimage.onload = function (e) {
                $('#image_preview_container').attr('src', e.target.result);
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/themes/darkmode/user/profile/myprofile.blade.php ENDPATH**/ ?>